Bmin=2;
Bmax=20;
ThetaMin=0;
Theta=1;
C=-10;
delta = 0.001;

step=0.01;
xv=[Bmin:step:Bmax];

gv=[];
for i=1:max(size(xv))
   x=xv(i);
   H=C^2+2*x*C*(Theta-ThetaMin+1);
   
   if (H>=0)
     g=Bmax;
   else
      w=x*abs(C)/sqrt(-1*H);
      if (w>Bmax)
          w=Bmax;
      elseif (w<Bmin)
          w=Bmin;
      end
      g=w;
   end
   gv = [gv g];
   if (abs(x-g)<=delta)
       xstar = x;
   end
end

plot(xv,gv, '-', xv, xv,'--', xstar, xstar, '-k*', 'LineWidth', 3)
ylim([(Bmin-1) (Bmax+1)])
set(gca, 'FontSize', 14);
xlabel('x', 'FontSize',18)
ylabel('g_k(x)', 'FontSize', 18)
title('The function g_k and its fixed point')
